  
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  5 December 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version ODRM_TLK_ATP_UTIL.c#1:csrc:1
   *  \author Sagit Ben Tsur
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ***********************************/
#include "ODRM_TLK_ATP_Defines.h" 
#include "ODRM_TLK_ATP_UTIL.h"
#include "DX_VOS_Stdio.h"
#include <stdarg.h>
#include <stdio.h>
/************************ Defines ******************************/
/************************ Enums ********************************/
/************************ Typedefs *****************************/
/************************ Global Data **************************/
/************* Private function prototype **********************/
/************************ Public Functions *********************/

/*****************************************************************************
 * Function Name:                                                           
 *  ATP_LOG_TST_PRINT       
 * 
 * Inputs:
 *  DxUint8_t level - the printing level if it is below the ATP_LOG_TST_MAX_LEVEL_ENABLED
 *                    flag setting it will not be printed.
 *  const char format,... - the printf format.   
 *  
 * Outputs:
 *   None                                   
 *
 * Description:                                                                 
 * The following function Handel the printings logging of the testing suite . 
 *        This function should be called by using the ATP_LOG_TST_PLOT macro
 *
 ******************************************************************************/
#if ATP_LOG_TST_MAX_LEVEL_ENABLED

int ODRMTLK_LOG_TST( DxUint8_t level , const char *format,... )
{

/* LOCAL DECLERATIONS */
  va_list ap;
  FILE *TST_log_ptr = DX_NULL;

  /* FUNCTION LOGIC */
   /* if (TST_log_fname_ptr != DX_NULL)
    {
       TST_log_ptr = fopen(TST_log_fname_ptr ,"a+");
       if (TST_log_ptr == DX_NULL)
       {
           printf("CANT OPEN LOG FILE \n");
           return TST_FAIL;
       }
    }
    else*/
        TST_log_ptr = stdout;
    /* if the printing level is enabled then print it */
    if( level < ATP_LOG_TST_MAX_LEVEL_ENABLED )
    {
        va_start(ap, format);
        vfprintf( TST_log_ptr,format , ap );
        va_end(ap);
    }
    /*if (TST_log_fname_ptr != DX_NULL)
        fclose(TST_log_ptr);*/
  return ODRMTLK_TEST_PASS;  
}/* END OF ATP_LOG_TST */

#endif

/*****************************************************************************
 * Function Name:                                                           
 *  ODRMTLK_TST_CheckErrorReturn        
 * 
 * Inputs:
 *  DxUint32_t  TST_ErrorRet - The return value of the checked function
 *  char TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name 
 *  char     TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
 *  char     TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name 
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * This function Is a utility function to save up some space 
 * this function returns the appropriate printing for a checked function 
 * If the operation had succeeded of failed the appropriate printing and return value
 *
 ******************************************************************************/
DxError_t ODRMTLK_TST_CheckErrorReturn(DxError_t TST_ErrorRet, 
                                       char    TST_FuncName[TST_FUNC_STRING_LEN],
                                       char    TST_SubTestName[TST_FUNC_STRING_LEN],
                                       char    TST_MasterTestName[TST_FUNC_STRING_LEN])
{
    if ((TST_ErrorRet == DX_SUCCESS))
        {
            ODRMTLK_LOG_TST_PRINT((ODRMTLK_TST_MSG,"TST_message - "));
            ODRMTLK_LOG_TST_PRINT((ODRMTLK_TST_MSG,"%s",TST_FuncName));
            ODRMTLK_LOG_TST_PRINT((ODRMTLK_TST_MSG," pass \n"));                                       
            return ODRMTLK_TEST_PASS;
        }
    else
        {
            ODRMTLK_LOG_TST_PRINT((ODRMTLK_TST_MSG,"\n!!!! TST_Error - Master Test Name -%s\n",TST_MasterTestName));
            ODRMTLK_LOG_TST_PRINT((ODRMTLK_TST_MSG,"!!!! TST_Error - SubTest Name -%s\n",TST_SubTestName));            
            ODRMTLK_LOG_TST_PRINT((ODRMTLK_TST_MSG,"!!!! TST_Error - %s failed\n",TST_FuncName));
            ODRMTLK_LOG_TST_PRINT((ODRMTLK_TST_MSG,"!!!! TST_Error - Return code %lX \n",TST_ErrorRet));   
            return ODRMTLK_TEST_FAIL;
        }
}

